required_packages <- c("readxl","sjPlot","broom","ggplot2")
# Install and load packages if not already installed
for (package in required_packages) {
  if (!requireNamespace(package, quietly = TRUE)) {
    install.packages(package)
  }
  library(package, character.only = TRUE)
}

#import data frame
if (!exists("df")) {
  file_path <- "~/cohort.xlsx"
  df <- read_excel(file_path, sheet = "cohort", na = "#N/A")
}

#filter df
df_filtered <- df[, c("r_upper_suv_mean", "r_upper_suv_min", "r_upper_suv_max","r_upper_suv_sd", 
                      "r_lower_suv_mean", "r_lower_suv_min", "r_lower_suv_max","r_lower_suv_sd",
                      "l_upper_suv_mean", "l_upper_suv_min", "l_upper_suv_max","l_upper_suv_sd",
                      "l_lower_suv_mean", "l_lower_suv_min", "l_lower_suv_max","l_lower_suv_sd",
                      "liver1_suv_mean" , "liver1_suv_min","liver1_suv_max","liver1_suv_sd",
                      "liver2_suv_mean","liver2_suv_min","liver2_suv_max","liver2_suv_sd",
                      "aorta_suv_mean","aorta_suv_min","aorta_suv_max","aorta_suv_sd", "side_r0_l1",
                      "sex_male","age","copd","nicotine","packyears","bmi",
                      "pet_device","diabetes","pleural_effusion","pet_distance_ic")]

df_filtered[] <- lapply(df_filtered, as.numeric)
df_filtered <- subset(df_filtered, pet_distance_ic <= 365 | is.na(pet_distance_ic))
df_filtered <- subset(df_filtered, pet_distance_ic >= -1)

#add cols
cols <- c("no_tumor_suv_mean", "no_tumor_suv_min", "no_tumor_suv_max", "no_tumor_suv_sd", 
          "suv_70", "suv_75", "suv_80", "suv_85", "suv_90", "suv_95", "no_tumor_suv_95", "upper_suv_95", "lower_suv_95", 
          "liver_ratio_mean", "liver_ratio_max", "liver_ratio_min", "liver_ratio_sd",
          "liver_ratio_lower_mean", "liver_ratio_lower_max", "liver_ratio_lower_min", "liver_ratio_lower_sd",
          "liver_ratio_upper_mean", "liver_ratio_upper_max", "liver_ratio_upper_min", "liver_ratio_upper_sd",
          "liver_no_tumor_ratio_mean", "liver_no_tumor_ratio_max", "liver_no_tumor_ratio_min", "liver_no_tumor_ratio_sd",
          "aorta_ratio_mean", "aorta_ratio_max", "aorta_ratio_min", "aorta_ratio_sd",
          "aorta_ratio_lower_mean", "aorta_ratio_lower_max", "aorta_ratio_lower_min", "aorta_ratio_lower_sd",
          "aorta_ratio_upper_mean", "aorta_ratio_upper_max", "aorta_ratio_upper_min", "aorta_ratio_upper_sd",
          "aorta_no_tumor_ratio_mean", "aorta_no_tumor_ratio_max", "aorta_no_tumor_ratio_min", "aorta_no_tumor_ratio_sd",
          "ged960")
df_filtered[,cols] <- NA

#calculate SUV
for (i in 1:nrow(df_filtered)) {
  if (is.na(df_filtered$l_upper_suv_mean[i]) & !is.na(df_filtered$r_upper_suv_mean[i])) {
    df_filtered$l_upper_suv_max[i] <- df_filtered$r_upper_suv_max[i]
    df_filtered$l_upper_suv_min[i] <- df_filtered$r_upper_suv_min[i]
    df_filtered$l_upper_suv_mean[i] <- df_filtered$r_upper_suv_mean[i]
    df_filtered$l_upper_suv_sd[i] <- df_filtered$r_upper_suv_sd[i]
  }
  if (is.na(df_filtered$r_upper_suv_mean[i]) & !is.na(df_filtered$l_upper_suv_mean[i])) {
    df_filtered$r_upper_suv_max[i] <- df_filtered$l_upper_suv_max[i]
    df_filtered$r_upper_suv_min[i] <- df_filtered$l_upper_suv_min[i]
    df_filtered$r_upper_suv_mean[i] <- df_filtered$l_upper_suv_mean[i]
    df_filtered$r_upper_suv_sd[i] <- df_filtered$l_upper_suv_sd[i]
  }
  if (is.na(df_filtered$l_lower_suv_mean[i]) & !is.na(df_filtered$r_lower_suv_mean[i])) {
    df_filtered$l_lower_suv_max[i] <- df_filtered$r_lower_suv_max[i]
    df_filtered$l_lower_suv_min[i] <- df_filtered$r_lower_suv_min[i]
    df_filtered$l_lower_suv_mean[i] <- df_filtered$r_lower_suv_mean[i]
    df_filtered$l_lower_suv_sd[i] <- df_filtered$r_lower_suv_sd[i]
  }
  if (is.na(df_filtered$r_lower_suv_mean[i]) & !is.na(df_filtered$l_lower_suv_mean[i])) {
    df_filtered$r_lower_suv_max[i] <- df_filtered$l_lower_suv_max[i]
    df_filtered$r_lower_suv_min[i] <- df_filtered$l_lower_suv_min[i]
    df_filtered$r_lower_suv_mean[i] <- df_filtered$l_lower_suv_mean[i]
    df_filtered$r_lower_suv_sd[i] <- df_filtered$l_lower_suv_sd[i]
  }
  if (is.na(df_filtered$liver1_suv_mean[i]) & !is.na(df_filtered$liver2_suv_mean[i])) {
    df_filtered$liver1_suv_max[i] <- df_filtered$liver2_suv_max[i]
    df_filtered$liver1_suv_min[i] <- df_filtered$liver2_suv_min[i]
    df_filtered$liver1_suv_mean[i] <- df_filtered$liver2_suv_mean[i]
    df_filtered$liver1_suv_sd[i] <- df_filtered$liver2_suv_sd[i]
  }
  if (is.na(df_filtered$liver2_suv_mean[i]) & !is.na(df_filtered$liver1_suv_mean[i])) {
    df_filtered$liver2_suv_max[i] <- df_filtered$liver1_suv_max[i]
    df_filtered$liver2_suv_min[i] <- df_filtered$liver1_suv_min[i]
    df_filtered$liver2_suv_mean[i] <- df_filtered$liver1_suv_mean[i]
    df_filtered$liver2_suv_sd[i] <- df_filtered$liver1_suv_sd[i]
  }
  if (!is.na(df_filtered$side_r0_l1[i])) {
    if (df_filtered$side_r0_l1[i] == 1 & !is.na(df_filtered$l_lower_suv_mean[i])) {
      df_filtered$no_tumor_suv_mean[i] <- mean(df_filtered$l_lower_suv_mean[i], df_filtered$l_upper_suv_mean[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_min[i] <- mean(df_filtered$l_lower_suv_min[i], df_filtered$l_upper_suv_min[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_max[i] <- mean(df_filtered$l_lower_suv_max[i], df_filtered$l_upper_suv_max[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_sd[i] <- mean(df_filtered$l_lower_suv_sd[i], df_filtered$l_upper_suv_sd[i], na.rm = TRUE)
    } else if (df_filtered$side_r0_l1[i] == 0 & !is.na(df_filtered$r_lower_suv_mean[i])) {
      df_filtered$no_tumor_suv_mean[i] <- mean(df_filtered$r_lower_suv_mean[i], df_filtered$r_upper_suv_mean[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_min[i] <- mean(df_filtered$r_lower_suv_min[i], df_filtered$r_upper_suv_min[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_max[i] <- mean(df_filtered$r_lower_suv_max[i], df_filtered$r_upper_suv_max[i], na.rm = TRUE)
      df_filtered$no_tumor_suv_sd[i] <- mean(df_filtered$r_lower_suv_sd[i], df_filtered$r_upper_suv_sd[i], na.rm = TRUE)
    }
  }
}

df_filtered$upper_suv_mean <- rowMeans(df_filtered[, c("r_upper_suv_mean", "l_upper_suv_mean")], na.rm = TRUE)
df_filtered$upper_suv_max <- rowMeans(df_filtered[, c("r_upper_suv_max", "l_upper_suv_max")], na.rm = TRUE)
df_filtered$upper_suv_min <- rowMeans(df_filtered[, c("r_upper_suv_min", "l_upper_suv_min")], na.rm = TRUE)
df_filtered$upper_suv_sd <- rowMeans(df_filtered[, c("r_upper_suv_sd", "l_upper_suv_sd")], na.rm = TRUE)

df_filtered$lower_suv_mean <- rowMeans(df_filtered[, c("r_lower_suv_mean", "l_lower_suv_mean")], na.rm = TRUE)
df_filtered$lower_suv_max <- rowMeans(df_filtered[, c("r_lower_suv_max", "l_lower_suv_max")], na.rm = TRUE)
df_filtered$lower_suv_min <- rowMeans(df_filtered[, c("r_lower_suv_min", "l_lower_suv_min")], na.rm = TRUE)
df_filtered$lower_suv_sd <- rowMeans(df_filtered[, c("r_lower_suv_sd", "l_lower_suv_sd")], na.rm = TRUE)

df_filtered$suv_lung_mean <- rowMeans(df_filtered[, c("upper_suv_mean", "lower_suv_mean")], na.rm = TRUE)
df_filtered$suv_lung_max <- rowMeans(df_filtered[, c("upper_suv_max", "lower_suv_max")], na.rm = TRUE)
df_filtered$suv_lung_min <- rowMeans(df_filtered[, c("upper_suv_min", "lower_suv_min")], na.rm = TRUE)
df_filtered$suv_lung_sd <- rowMeans(df_filtered[, c("upper_suv_sd", "lower_suv_sd")], na.rm = TRUE)

df_filtered$liver_suv_mean <- rowMeans(df_filtered[, c("liver1_suv_mean", "liver2_suv_mean")], na.rm = TRUE)
df_filtered$liver_suv_max <- rowMeans(df_filtered[, c("liver1_suv_max", "liver2_suv_max")], na.rm = TRUE)
df_filtered$liver_suv_min <- rowMeans(df_filtered[, c("liver1_suv_min", "liver2_suv_min")], na.rm = TRUE)
df_filtered$liver_suv_sd <- rowMeans(df_filtered[, c("liver1_suv_sd", "liver2_suv_sd")], na.rm = TRUE)

for (i in 1:nrow(df_filtered)) {
  df_filtered$suv_70[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.70) * df_filtered$suv_lung_sd[i])
  df_filtered$suv_75[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.75) * df_filtered$suv_lung_sd[i])
  df_filtered$suv_80[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.80) * df_filtered$suv_lung_sd[i])
  df_filtered$suv_85[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.85) * df_filtered$suv_lung_sd[i])
  df_filtered$suv_90[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.90) * df_filtered$suv_lung_sd[i])
  df_filtered$suv_95[i] <- df_filtered$suv_lung_mean[i] + (qnorm(0.95) * df_filtered$suv_lung_sd[i])
  if (!is.na(df_filtered$no_tumor_suv_mean[i])) {
    df_filtered$no_tumor_suv_95[i] <- df_filtered$no_tumor_suv_mean[i] + (qnorm(0.95) * df_filtered$no_tumor_suv_sd[i])
    df_filtered$upper_suv_95[i] <- df_filtered$upper_suv_mean[i] + (qnorm(0.95) * df_filtered$upper_suv_sd[i])
    df_filtered$lower_suv_95[i] <- df_filtered$lower_suv_mean[i] + (qnorm(0.95) * df_filtered$lower_suv_sd[i])
  }
  df_filtered$liver_ratio_mean[i] <- (df_filtered$suv_lung_mean[i] /df_filtered$liver_suv_mean[i]) 
  df_filtered$liver_ratio_max[i] <- (df_filtered$suv_lung_max[i]/df_filtered$liver_suv_max[i]) 
  df_filtered$liver_ratio_min[i] <- (df_filtered$suv_lung_min[i]/df_filtered$liver_suv_min[i]) 
  df_filtered$liver_ratio_sd[i] <- (df_filtered$suv_lung_sd[i]/df_filtered$liver_suv_sd[i]) 
  
  df_filtered$liver_ratio_upper_mean[i] <- (df_filtered$upper_suv_mean[i]/df_filtered$liver_suv_mean[i]) 
  df_filtered$liver_ratio_upper_max[i] <- (df_filtered$upper_suv_max[i]/df_filtered$liver_suv_max[i]) 
  df_filtered$liver_ratio_upper_min[i] <- (df_filtered$upper_suv_min[i]/df_filtered$liver_suv_min[i])
  df_filtered$liver_ratio_upper_sd[i] <- (df_filtered$upper_suv_sd[i]/df_filtered$liver_suv_sd[i])
  
  df_filtered$liver_ratio_lower_mean[i] <- (df_filtered$lower_suv_mean[i]/df_filtered$liver_suv_mean[i]) 
  df_filtered$liver_ratio_lower_max[i] <- (df_filtered$lower_suv_max[i]/df_filtered$liver_suv_max[i]) 
  df_filtered$liver_ratio_lower_min[i] <- (df_filtered$lower_suv_min[i]/df_filtered$liver_suv_min[i])
  df_filtered$liver_ratio_lower_sd[i] <- (df_filtered$lower_suv_sd[i]/df_filtered$liver_suv_sd[i])
  
  if (!is.na(df_filtered$no_tumor_suv_mean[i])) {
    df_filtered$liver_no_tumor_ratio_mean[i] <- (df_filtered$no_tumor_suv_mean[i]/df_filtered$liver_suv_mean[i]) 
    df_filtered$liver_no_tumor_ratio_max[i]<- (df_filtered$no_tumor_suv_max[i]/df_filtered$liver_suv_max[i]) 
    df_filtered$liver_no_tumor_ratio_min[i]<- (df_filtered$no_tumor_suv_min[i]/df_filtered$liver_suv_min[i]) 
    df_filtered$liver_no_tumor_ratio_sd[i]<- (df_filtered$no_tumor_suv_sd[i]/df_filtered$liver_suv_sd[i]) 
  }
  df_filtered$aorta_ratio_mean[i] <- (df_filtered$suv_lung_mean[i]/df_filtered$aorta_suv_mean[i]) 
  df_filtered$aorta_ratio_max[i] <- (df_filtered$suv_lung_max[i]/df_filtered$aorta_suv_max[i]) 
  df_filtered$aorta_ratio_min[i] <- (df_filtered$suv_lung_min[i]/df_filtered$aorta_suv_min[i]) 
  df_filtered$aorta_ratio_sd[i] <- (df_filtered$suv_lung_sd[i]/df_filtered$aorta_suv_sd[i]) 
  
  df_filtered$aorta_ratio_upper_mean[i] <- (df_filtered$upper_suv_mean[i]/df_filtered$aorta_suv_mean[i]) 
  df_filtered$aorta_ratio_upper_max[i] <- (df_filtered$upper_suv_max[i]/df_filtered$aorta_suv_max[i]) 
  df_filtered$aorta_ratio_upper_min[i] <- (df_filtered$upper_suv_min[i]/df_filtered$aorta_suv_min[i]) 
  df_filtered$aorta_ratio_upper_sd[i] <- (df_filtered$upper_suv_sd[i]/df_filtered$aorta_suv_sd[i])
  
  df_filtered$aorta_ratio_lower_mean[i] <- (df_filtered$lower_suv_mean[i]/df_filtered$aorta_suv_mean[i]) 
  df_filtered$aorta_ratio_lower_max[i] <- (df_filtered$lower_suv_max[i]/df_filtered$aorta_suv_max[i]) 
  df_filtered$aorta_ratio_lower_min[i] <- (df_filtered$lower_suv_min[i]/df_filtered$aorta_suv_min[i])
  df_filtered$aorta_ratio_lower_sd[i] <- (df_filtered$lower_suv_sd[i]/df_filtered$aorta_suv_sd[i])
  
  if (!is.na(df_filtered$no_tumor_suv_mean[i])) {
    df_filtered$aorta_no_tumor_ratio_mean[i] <- (df_filtered$no_tumor_suv_mean[i]/df_filtered$aorta_suv_mean[i]) 
    df_filtered$aorta_no_tumor_ratio_max[i]<- (df_filtered$no_tumor_suv_max[i]/df_filtered$aorta_suv_max[i]) 
    df_filtered$aorta_no_tumor_ratio_min[i]<- (df_filtered$no_tumor_suv_min[i]/df_filtered$aorta_suv_min[i]) 
    df_filtered$aorta_no_tumor_ratio_sd[i] <- (df_filtered$no_tumor_suv_sd[i]/df_filtered$aorta_suv_sd[i]) 
  }
}

#rename variables in df
colnames(df_filtered)[colnames(df_filtered) == "bmi"] <- "BMI"
colnames(df_filtered)[colnames(df_filtered) == "copd"] <- "COPD"

#clear filtered df
df_cleared <- df_filtered[, c("suv_lung_mean", "suv_95", "suv_lung_max","BMI", "COPD","pet_device")]
df_cleared <- subset(df_cleared, pet_device == 6)
df_cleared <- na.omit(df_cleared)

#regression
modelMAX <- lm(suv_lung_max ~  BMI + COPD, data = df_filtered)
modelMEAN <- lm(suv_lung_mean ~ BMI + COPD, data = df_cleared)
model95 <- lm(suv_95 ~ BMI + COPD, data = df_cleared)

forest = plot_models(modelMAX, modelMEAN, model95, std.est = "std2",  
                     axis.labels = c("COPD","BMI"),
                     m.labels = c("Mean SUVmax", "Mean SUVmean", "Mean SUV95"),
                     title = "",
                     legend.title = "SUV Calculations",p.shape = TRUE,vline.color = "black")
ggsave("Figure S3. Forest plot of subgroup.png", forest, width = 1800, height = 150+200*3, units = "px")
print("saved: Figure S3. Forest plot of subgroup.png")

